/*
 * Decompiled with CFR 0.152.
 */
package jclass.cell.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.TextArea;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import jclass.cell.CellEditor;
import jclass.cell.CellEditorEvent;
import jclass.cell.CellEditorListener;
import jclass.cell.CellEditorSupport;
import jclass.cell.CellInfo;
import jclass.cell.InitialEvent;
import jclass.cell.KeyModifier;
import jclass.cell.ValidateEvent;
import jclass.cell.ValidateInterface;
import jclass.cell.ValidateListener;
import jclass.cell.ValidateSupport;
import jclass.util.JCEnvironment;
import jclass.util.JCWordWrap;

public class WordWrapCellEditor
extends TextArea
implements CellEditor,
ValidateInterface,
KeyListener {
    protected Object data;
    protected CellInfo cellInfo;
    protected String originalText;
    protected InitialEvent initialEvent;
    protected CellEditorSupport support = new CellEditorSupport();
    protected boolean selectAll = false;
    protected boolean editable = true;
    protected ValidateSupport validate_support = new ValidateSupport();
    final int VERTICAL_SB_WIDTH = 25;
    protected KeyModifier[] keys;

    public WordWrapCellEditor() {
        this.addKeyListener(this);
    }

    public void initialize(InitialEvent initialEvent, CellInfo cellInfo, Object object) {
        this.initialEvent = initialEvent;
        this.cellInfo = cellInfo;
        this.data = object;
        this.selectAll = cellInfo.getSelectAll();
        this.editable = cellInfo.isEditable();
        this.setEditable(this.editable);
        if (!this.isEditable()) {
            this.selectAll = false;
        }
        if (this.data != null) {
            FontMetrics fontMetrics = cellInfo.getFontMetrics();
            Insets insets = cellInfo.getBorderInsets();
            int n = cellInfo.getDrawingArea().width + insets.left + insets.right;
            String string = this.data.toString();
            if ((JCEnvironment.getOS() == 1 || JCEnvironment.getJavaVersion() == 102) && (char)initialEvent.getKey() >= ' ' && (char)initialEvent.getKey() <= '~') {
                string = String.valueOf(string) + String.valueOf((char)initialEvent.getKey());
            }
            this.setText(JCWordWrap.wrapText(string, fontMetrics, n - 25, "\n", true));
        } else {
            this.setText("");
        }
        this.originalText = this.getText();
        ((Component)this).setBackground(cellInfo.getBackground());
        this.setForeground(cellInfo.getForeground());
    }

    public Component getComponent() {
        return this;
    }

    public Object getCellEditorValue() {
        if (this.editable) {
            return JCWordWrap.replace(this.getText(), "\n", "");
        }
        return this.data;
    }

    protected boolean fireValidated(ValidateEvent validateEvent) {
        boolean bl = this.validate_support.fireValidateEvents(validateEvent);
        if (bl) {
            this.show();
        }
        return bl;
    }

    public boolean stopCellEditing() {
        String string = this.getText();
        ValidateEvent validateEvent = new ValidateEvent(this, this.data, string, true);
        boolean bl = this.fireValidated(validateEvent);
        if (bl) {
            this.selectAllText();
        }
        return bl;
    }

    public boolean isModified() {
        if (this.data == null) {
            return this.getCellEditorValue() != null;
        }
        return !this.data.equals(this.getCellEditorValue());
    }

    public void cancelCellEditing() {
        this.setText(this.originalText);
        this.selectAllText();
    }

    public Dimension minimumSize() {
        return this.minimumSize(3, 5);
    }

    public Dimension getPreferredSize(CellInfo cellInfo, Object object) {
        return this.preferredSize();
    }

    public KeyModifier[] getReservedKeys() {
        if (this.keys == null) {
            this.keys = new KeyModifier[9];
            this.keys[0] = new KeyModifier(10);
            this.keys[1] = new KeyModifier(40);
            this.keys[2] = new KeyModifier(38);
            this.keys[3] = new KeyModifier(37);
            this.keys[4] = new KeyModifier(39);
            this.keys[5] = new KeyModifier(33);
            this.keys[6] = new KeyModifier(34);
            this.keys[7] = new KeyModifier(36);
            this.keys[8] = new KeyModifier(35);
        }
        return this.keys;
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.support.addCellEditorListener(cellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.support.removeCellEditorListener(cellEditorListener);
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                if ((keyEvent.getModifiers() & 2) == 0) break;
                this.support.fireStopEditing(new CellEditorEvent(keyEvent));
                return;
            }
            case 27: {
                this.support.fireCancelEditing(new CellEditorEvent(keyEvent));
                return;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void selectAllText() {
        if (this.getPeer() == null) {
            return;
        }
        if (this.selectAll) {
            this.setCaretPosition(0);
            this.setCaretPosition(this.data == null ? 0 : this.data.toString().length());
            this.selectAll();
            return;
        }
        this.setCaretPosition(this.data == null ? 0 : this.data.toString().length());
    }

    String unwrapText(String string) {
        return JCWordWrap.replace(string, "\n", "");
    }

    String wrapText(String string) {
        String string2 = "";
        if (string != null) {
            FontMetrics fontMetrics = this.cellInfo.getFontMetrics();
            Insets insets = this.cellInfo.getBorderInsets();
            int n = this.cellInfo.getDrawingArea().width + insets.left + insets.right;
            string2 = JCWordWrap.wrapText(string, fontMetrics, n - 25, "\n", true);
        }
        return string2;
    }

    public void show() {
        super.show();
        this.selectAllText();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.setText(this.wrapText(this.unwrapText(this.getText())));
    }

    public void addValidateListener(ValidateListener validateListener) {
        this.validate_support.addValidateListener(validateListener);
    }

    public void removeValidateListener(ValidateListener validateListener) {
        this.validate_support.removeValidateListener(validateListener);
    }
}

